/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx__lib_types.h"
#include "mx__lib.h"
#include "mx__driver_interface.h"
#include "mx_byteswap.h"
#  include "mx__partner.h"
#include "mx__endpoint.h"
#include "mx__fops.h"
#include "mx__error.h"

#ifdef MX_VERSIONED_SYMS

mx_return_t
mx_compose_endpoint_addr_v1(uint64_t nic_id, uint32_t endpoint_id,
			 uint32_t app_key, mx_endpoint_addr_t *addr)
{
  mx_return_t ret;

  ret = mx_connect(Mx_endpoints, nic_id, endpoint_id, app_key, MX_INFINITE, addr);
  return mx__error_noep("mx_compose_endpoint_addr/connect", ret);
}

__asm__(".symver mx_compose_endpoint_addr_v1,mx_compose_endpoint_addr@MX_0.0");

#endif
